<?php

namespace App\Classes;

use App\Models\Lang;
use App\Models\Translation;
use Nwidart\Modules\Facades\Module;

class LangTrans
{
    public static $mainTranslations = [
        'common' => [
            'enabled' => 'Enabled',
            'disabled' => 'Disabled',
            'id' => 'Id',
            'action' => 'Action',
            'placeholder_default_text' => 'Please Enter {0}',
            'placeholder_social_text' => 'Please Enter {0} Url',
            'placeholder_search_text' => 'Search By {0}',
            'select_default_text' => 'Select {0}...',
            'create' => 'Create',
            'edit' => 'Edit',
            'update' => 'Update',
            'cancel' => 'Cancel',
            'delete' => 'Delete',
            'success' => 'Success',
            'error' => 'Error',
            'yes' => 'Yes',
            'no' => 'No',
            'fix_errors' => 'Please Fix Below Errors.',
            'cancelled' => 'Cancelled',
            'pending' => 'Pending',
            'paid' => 'Paid',
            'completed' => 'Completed',
            'save' => 'Save',
            'all' => 'All',
            'name' => 'Name',
            'back' => 'Back',
            'max_amount' => 'Max. Amount',
            'date_time' => 'Date Time',
            'select_time' => 'Select Time',
            'start_date' => 'Start Date',
            'end_date' => 'End Date',
            'search' => 'Search',
            'date' => 'Date',
            'out_of_stock' => 'Out Of Stock',
            'pay' => 'Pay',
            'received' => 'Received',
            'with_tax' => 'With Tax',
            'without_tax' => 'Without Tax',
            'invoice_number' => 'Invoice Number',
            'ordered' => 'Ordered',
            'confirmed' => 'Confirmed',
            'processing' => 'Processing',
            'shipping' => 'Shipping',
            'delivered' => 'Delivered',
            'confirm' => 'Confirm',
            'title' => 'Title',
            'value' => 'Value',
            'add' => 'Add',
            'view' => 'View',
            'edit' => 'Edit',
            'download' => 'Download',
            'change_order_status' => 'Change Order Status',
            'total' => 'Total',
            'print_invoice' => 'Print Invoice',
            'email' => 'Email',
            'phone' => 'Phone',
            'item' => 'Item',
            'items' => 'Items',
            'qty' => 'Qty',
            'rate' => 'Rate',
            'purchase_code' => 'Purchase Code',
            'verify_purchase' => 'Verify Purchase',
            'buy_now' => 'Buy Now',
            'install' => 'Install',
            'installing' => 'Installing',
            'updating' => 'Updating',
            'free' => 'Free',
            'paid' => 'Paid',
            'domain' => 'Domain',
            'verify' => 'Verify',
            'send' => 'Send',
            'upload' => 'Upload',
            'view_all' => 'View All',
            'unpaid' => 'Unpaid',
            'loading' => 'Loading',
            'update_app' => 'Update App',
            'welcome_back' => 'Welcome {0}',
            'off' => 'Off',
            'on_create' => 'On Create',
            'on_update' => 'On Update',
            'on_delete' => 'On Delete',
            'demo_account_credentials' => 'Demo account login credentials',
            'balance' => 'Balance',
            'party' => 'Party',
            'created_by' => 'Created By',
            'import' => 'Import',
            'file' => 'File',
            'copy_url' => 'Copy Url',
            'print' => 'Print',
            'pdf' => 'Pdf',
            'particulars' => 'Particulars',
            'amount' => 'Amount',
            'profit' => 'Profit',
            'profit_reports_by_orders' => 'Profit Reports By Orders',
            'profit_reports_by_payments' => 'Profit Reports By Payments',
            'status' => 'Status',
            'active' => 'Active',
            'inactive' => 'Inactive',
            'verified' => 'Verified',
            'configure' => 'Configure',
            'logo' => 'Logo',
            'comment' => 'Comment',
            'rating' => 'Rating',
            'page_content' => 'Page Content',
            'slug' => 'Slug',
            'question' => 'Question',
            'answer' => 'Answer',
            'description' => 'Description',
            'image' => 'Image',
            'address' => 'Address',
            'not_allowed' => 'Not Allowed',
            'details' => 'Details',
            'excel' => 'Excel',
            'daily_income' => 'Daily Income',
            'average_price' => 'Average Price',
            'module' => 'Module',
            'save_and_new' => 'Save & New',
            'save_and_continue' => 'Save & Continue',
            'clear' => 'Clear',
            'filters' => 'Filters',
            'reset' => 'Reset',
            'preview' => 'Preview',
            'minutes' => 'Minutes',
            'pending' => 'Pending',
            'approved' => 'Approved',
            'rejected' => 'Rejected',
            'january' => 'January',
            'february' => 'February',
            'march' => 'March',
            'april' => 'April',
            'may' => 'May',
            'june' => 'June',
            'july' => 'July',
            'august' => 'August',
            'september' => 'September',
            'october' => 'October',
            'november' => 'November',
            'december' => 'December',
            'hrm_permissions' => 'HRM Permissions',
            'am' => 'AM',
            'pm' => 'PM',
            'approved_message' => 'Are you sure you want to change status to approved?',
            'rejected_message' => 'Are you sure you want to change status to rejected?',
            'status_changed' => 'Status Changed',
            'all' => 'All',
            'holiday' => 'Holiday',
            'weekends' => 'Weekends',
            'month' => 'Month',
            'date' => 'Date',
            'yes' => 'Yes',
            'no' => 'No',
            'generated' => 'Salary Generated Sucessfully',
            'assign_to_all' => 'Assign To All',
            'edit_all' => 'Edit All',
            'delete_all' => 'Delete All',
            'approve_reject' => 'Approve/Reject',
            'summary' => 'Summary',
            'leave' => 'Leave',
            'time' => 'Time',
            'sunday' => 'Sunday',
            'monday' => 'Monday',
            'tuesday' => 'Tuesday',
            'wednesday' => 'Wednesday',
            'thursday' => 'Thursday',
            'friday' => 'Friday',
            'saturday' => 'Saturday',
            'pos_invoice' => 'POS Invoice',
            'download_invoice' => 'Download Invoice',
        ],

        'menu' => [
            'dashboard' => 'Dashboard',
            'stock_management' => 'Stock Manager',
            'purchase' => 'Purchase',
            'purchases' => 'Purchases',
            'purchase_returns' => 'Purchase Return / Dr. Note',
            'sales' => 'Sales',
            'sales_return' => 'Sales Return',
            'sales_returns' => 'Sales Return / Cr. Note',
            'product_manager' => 'Product Manager',
            'brands' => 'Brands',
            'categories' => 'Categories',
            'products' => 'Products',
            'expense_manager' => 'Expenses',
            'expense_categories' => 'Expense Categories',
            'expenses' => 'Expenses',
            'users' => 'Users',
            'parties' => 'Parties',
            'staff_members' => 'Staff Members',
            'customers' => 'Customers',
            'suppliers' => 'Suppliers',
            'settings' => 'Settings',
            'company' => 'Company Settings',
            'profile' => 'Profile',
            'translations' => 'Translations',
            'languages' => 'Languages',
            'warehouses' => 'Warehouses',
            'roles' => 'Role & Permissions',
            'taxes' => 'Taxes',
            'currencies' => 'Currencies',
            'payment_modes' => 'Payment Modes',
            'units' => 'Units',
            'login' => 'Login',
            'logout' => 'Logout',
            'reports' => 'Reports',
            'order_payments' => 'Order Payments',
            'payments' => 'Payments',
            'stock_alert' => 'Stock Alert',
            'users_reports' => 'Users Reports',
            'warehouses_reports' => 'Warehouses Reports',
            'pos' => 'POS',
            'stock_adjustment' => 'Stock Adjustment',
            'verify_product' => 'Verify Product',
            'modules' => 'Modules',
            'storage_settings' => 'Storage Settings',
            'email_settings' => 'Email Settings',
            'update_app' => 'Update App',
            'custom_fields' => 'Custom Fields',
            'payment_in' => 'Payment In',
            'payment_out' => 'Payment Out',
            'cash_bank' => 'Cash & Bank',
            'sales_summary' => 'Sales Summary',
            'stock_summary' => 'Stock Summary',
            'rate_list' => 'Rate List',
            'product_sales_summary' => 'Product Sales Summary',
            'homepage' => 'Buy online products',
            'online_orders' => 'Online Orders',
            'website_setup' => 'Website Setup',
            'product_cards' => 'Product Cards',
            'front_settings' => 'Front Settings',
            'orders' => 'Orders',
            'quotations' => 'Quotations',
            'quotation' => 'Quotation',
            'quotation_estimate' => 'Quotation / Estimate',
            'database_backup' => 'Database Backup',
            'stock_transfer' => 'Stock Transfer',
            'stock_transfers' => 'Stock Transfers',
            'profit_loss' => 'Profit & Loss',
            'companies' => 'Companies',
            'pos_settings' => 'POS Settings',
            'setup_company' => 'Setup Company',
            'expense_reports' => 'Expense Reports',
            'variations' => 'Variations',
            'print_barcodes' => 'Print Barcode',
            'reset_password' => 'Reset Password',
            'reset' => 'Reset',
            'submit' => 'Submit',
            'menu' => 'Menu',
            'create_account' => 'Create Account',
            'already_account_login_here' => 'Already Registered? Login here',
            'departments' => 'Departments',
            'designations' => 'Designations',
            'hrm' => 'HRM',
            'holidays' => 'Holidays',
            'weekends' => 'Weekends',
            'leaves_types' => 'Leave Types',
            'leaves' => 'Leaves',
            'shifts' => 'Shifts',
            'pre_payments' => 'Pre Payments',
            'attendances' => 'Attendance',
            'staff' => 'Staff',
            'all_holidays' => 'All Holidays',
            'leave_types' => 'Leave Types',
            'remaining_leaves' => 'Remaining Leaves',
            'unpaid_leaves' => 'Unpaid Leaves',
            'summary' => 'Summary',
            'awards' => 'Awards',
            'appreciations' => 'Appreciations',
            'increments_promotions' => 'Increment/Promotion',
            'payrolls' => 'Payroll',
            'dashboards' => 'HRM Dashboard',
            'attendance_details' => 'Attendance Details',
            'attendance_summary' => 'Attendance Summary',
            'basic_salaries' => 'Basic Salary',
            'hrm_settings' => 'HRM Settings',
        ],
        'mobile_app' => [
            'welcome_your_business_overview' => 'Welcome, your business overview',
            'today' => 'Today',
            'yesterday' => 'Yesterday',
            'weekly' => 'Weekly',
            'monthly' => 'Monthly',
            'yearly' => 'Yearly',
            'how_to_use_the_app' => 'How to use the app',
            'have_not_any_account' => 'Haven\'t any account?',
            'register' => 'Register',
        ],
        'department' => [
            'add' => 'Add New Department',
            'edit' => 'Edit Department',
            'created' => 'Department Created Successfully',
            'updated' => 'Department Updated Successfully',
            'deleted' => 'Department Deleted Successfully',
            'department_details' => 'Department Details',
            'delete_message' => 'Are you sure you want to delete this department?',
            'selected_delete_message' => 'Are you sure you want to delete selected department?',
            'display_name' => 'Display Name',
            'name' => 'Name',
            'user_id' => 'User',
            'shift_id' => 'Shift',
        ],
        'increment_promotion' => [
            'add' => 'Add New Increment/Promotion',
            'edit' => 'Edit Increment/Promotion',
            'created' => 'Increment/Promotion Created Successfully',
            'updated' => 'Increment/Promotion Updated Successfully',
            'deleted' => 'Increment/Promotion Deleted Successfully',
            'increment_and_promotion_details' => 'Increment/Promotion Details',
            'delete_message' => 'Are you sure you want to delete this increment/promotion?',
            'selected_delete_message' => 'Are you sure you want to delete selected increment/promotion?',
            'type' => 'Type',
            'date' => 'Date',
            'user_id' => 'User',
            'total_duration' => 'Total Duration',
            'description' => 'Description',
            'net_salary' => 'Net Salary',
            'promoted_designation_id' => 'Promoted Designation',
            'current_designation_id' => 'Current Designation',
            'increment' => 'Increment',
            'promotion' => 'Promotion',
            'increment_promotion' => 'Increment/Promotion',
            'details' => "Details",
            'update_basic_salary' => 'Update Basic Salary',
            'update_designation' => 'Update Designation'
        ],
        'designation' => [
            'add' => 'Add New Designation',
            'edit' => 'Edit Designation',
            'created' => 'Designation Created Successfully',
            'updated' => 'Designation Updated Successfully',
            'deleted' => 'Designation Deleted Successfully',
            'designation_details' => 'Designation Details',
            'delete_message' => 'Are you sure you want to delete this designation?',
            'selected_delete_message' => 'Are you sure you want to delete selected designation?',
            'display_name' => 'Display Name',
            'name' => 'Name',
        ],
        'holiday' => [
            'add' => 'Add New Holiday',
            'edit' => 'Edit Holiday',
            'created' => 'Holiday Created Successfully',
            'updated' => 'Holiday Updated Successfully',
            'deleted' => 'Holiday Deleted Successfully',
            'holiday_details' => 'Holiday Details',
            'delete_message' => 'Are you sure you want to delete this holiday?',
            'selected_delete_message' => 'Are you sure you want to delete selected holiday?',
            'display_name' => 'Display Name',
            'name' => 'Name',
            'year' => 'Year',
            'date' => 'Date',
            'mark_weekend_holiday' => 'Mark Weekend Holiday',
            'created_by' => 'Created By',
            'from' => 'From',
            'to' => 'To',
            'month' => 'Month',
            'ocassion_name' => 'Ocassion Name',
            'weekend_marked_successfully' => 'Weekend marked successfully',
        ],
        'leave_type' => [
            'add' => 'Add New Leave Type',
            'edit' => 'Edit Leave Type',
            'created' => 'Leave Type Created Successfully',
            'updated' => 'Leave Type Updated Successfully',
            'deleted' => 'Leave Type Deleted Successfully',
            'leave_type_details' => 'LeaveType Details',
            'delete_message' => 'Are you sure you want to delete this leave type?',
            'selected_delete_message' => 'Are you sure you want to delete selected leave type?',
            'display_name' => 'Display Name',
            'name' => 'Name',
            'is_paid' => 'Is Paid',
            'total_leaves' => 'Total Leaves',
            'leave_interval_count' => 'Leave Interval Count',
            'max_leaves_per_month' => 'Max Leaves Per Month',
        ],
        'leave' => [
            'add' => 'Add New Leave',
            'edit' => 'Edit Leave',
            'created' => 'Leave Created Successfully',
            'updated' => 'Leave Updated Successfully',
            'deleted' => 'Leave Deleted Successfully',
            'leave_details' => 'LeaveType Details',
            'delete_message' => 'Are you sure you want to delete this leave?',
            'selected_delete_message' => 'Are you sure you want to delete selected leave?',
            'display_name' => 'Display Name',
            'user_id' => 'User',
            'leave_type' => 'Leave Type',
            'is_paid' => 'Is Paid',
            'start_date' => 'Start Date',
            'end_date' => 'End Date',
            'is_half_day' => 'Is Half Day',
            'reason' => 'Reason',
            'file' => 'File',
            'status' => 'Status',
            'bill' => 'Bill',
            'date' => 'Date',
            'user' => 'User',
            'leave_status' => 'Leave Status',
            'department' => 'Department',
            'employees' => 'Employees',
            'mark_attendance' => 'Mark Attendance By',
            'clock_out' => 'Clock Out',
            'clock_in' => 'Clock In',
            'late' => 'Late',
            'half_day' => 'Half Day',
            'multiple_date' => 'You can select multiple dates',
            'clock_in_month' => 'Clock in Month',
            'attendance_overwrite' => 'Attendance Overwrite',
            'add_multiple' => 'Add Multiple Attendance',

        ],
        'award' => [
            'add' => 'Add New Award',
            'edit' => 'Edit Award',
            'created' => 'Award Created Successfully',
            'updated' => 'Award Updated Successfully',
            'deleted' => 'Award Deleted Successfully',
            'award_details' => 'Arwad Details',
            'delete_message' => 'Are you sure you want to delete this award?',
            'name' => 'Name',
            'active' => 'Active',
            'description' => 'Description',
            'award_price' => 'Award Price',
        ],
        'appreciation' => [
            'add' => 'Add New Appreciation',
            'edit' => 'Edit Appreciation',
            'created' => 'Appreciation Created Successfully',
            'updated' => 'Appreciation Updated Successfully',
            'deleted' => 'Appreciation Deleted Successfully',
            'appreciation_details' => 'Arwad Details',
            'delete_message' => 'Are you sure you want to delete this appreciation?',
            'date' => 'Date',
            'description' => 'Description',
            'user' => 'User',
            'award' => 'Award',
            'price_amount' => 'Price Amount',
            'price_given' => 'Price Given',
            'add_price_given' => 'Add Price Given',
            'price_given_placeholder' => 'Holiday Vouchar, Movie Tickets etc...'
        ],
        'shift' => [
            'add' => 'Add New Shift',
            'edit' => 'Edit Shift',
            'created' => 'Shift Created Successfully',
            'updated' => 'Shift Updated Successfully',
            'deleted' => 'Shift Deleted Successfully',
            'shift_details' => 'Shift Details',
            'delete_message' => 'Are you sure you want to delete this shift?',
            'selected_delete_message' => 'Are you sure you want to delete selected shift?',
            'display_name' => 'Display Name',
            'name' => 'Name',
            'clock_in_time' => 'Clock In Time',
            'clock_out_time' => 'Clock Out Time',
            'late_mark_after' => 'Late Mark After',
            'self_clocking' => 'Self Clocking',
            'allowed_ip_address' => 'Allowed IP Address',
            'add_new_ip_address' => 'Add New IP Address',
            'allow_clock_out_till' => 'Allow Clock Out Till',
            'early_clock_in_time' => 'Early Clock In Time',
        ],
        'pre_payment' => [
            'add' => 'Add New Pre Payment',
            'edit' => 'Edit Pre Payment',
            'created' => 'Pre Payment Created Successfully',
            'updated' => 'Pre Payment Updated Successfully',
            'deleted' => 'Pre Payment Deleted Successfully',
            'pre_payment_details' => 'Pre Payment Details',
            'delete_message' => 'Are you sure you want to delete this Pre Payment?',
            'selected_delete_message' => 'Are you sure you want to delete selected Pre Payment?',
            'user_id' => 'User',
            'payment_mode_id' => 'Payment Mode',
            'date_time' => 'Date',
            'amount' => 'Amount',
            'notes' => 'Notes',
            'month' => 'Month',
            'deduct_from_payroll' => 'Deduct From Payroll',
            'payroll_month' => 'Payroll Month',
            'payroll_year' => 'Payroll Year',
            'deduct_from_payroll' => 'Deduct From Payroll',
            'on_given_payment_month' => 'On Given Payment Month',
            'another_month' => 'Another Month',
            'deduct_month' => 'Deduct Month',
        ],
        'attendance' => [
            'add' => 'Add New Attendance',
            'edit' => 'Edit Attendance',
            'created' => 'Attendance Created Successfully',
            'updated' => 'Attendance Updated Successfully',
            'deleted' => 'Attendance Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this attendance?',
            'selected_delete_message' => 'Are you sure you want to delete selected attendance?',
            'month' => 'Month',
            'year' => 'Year',
            'user_id' => 'Staff Members',
            'name' => 'Staff Members',
            'present' => 'Present',
            'present_days' => 'Present Days',
            'working_days' => 'Working Days',
            'total_office_time' => 'Total Office Time',
            'half_day' => 'Half Days',
            'absent' => 'Absent',
            'holiday' => 'Holiday',
            'date' => 'Date',
            'on_leave' => 'On Leave',
            'status' => 'Status',
            'clock_in' => 'Clock In',
            'clock_out' => 'Clock Out',
            'clocked_time' => 'Clocked Time',
            'other_details' => 'Other Details',
            'clock_in_ip' => 'Clock-In IP',
            'clock_out_ip' => 'Clock-Out IP',
            'hours' => 'hrs',
            'minutes' => 'mins',
            'late' => 'Late',
            'not_marked' => 'Not Marked',
            'total_office_time' => 'Total Office Time',
            'total_worked_time' => 'Total Worked Time',
            'present_working_days' => 'Present / Working Days',
            'clock_in_date_time' => 'Clock In Time',
            'clock_out_date_time' => 'Clock Out Time',
            'clock_in_ip_address' => 'Clock In IP Address',
            'clock_out_ip_address' => 'Clock Out IP Address',
            'days' => 'Days',
            'total_duration' => 'Total Duration',
            'is_late' => 'Is Late',
            'admin' => 'Admin',
            'is_half_day' => 'Is Half Day',
            'leave_type' => 'Leave Type',
            'user' => 'Users',
            'half_days' => 'Half Days',
            'reason' => 'Reason',
        ],
        'payroll' => [
            'add' => 'Add New Payroll',
            'edit' => 'Edit Payroll',
            'created' => 'Payroll Created Successfully',
            'updated' => 'Payroll Updated Successfully',
            'deleted' => 'Payroll Deleted Successfully',
            'payroll_details' => 'Payroll Details',
            'delete_message' => 'Are you sure you want to delete this payroll?',
            'month' => 'Month',
            'year' => 'Year',
            'user_id' => 'User',
            'net_salary' => 'Net Salary',
            'status' => 'Status',
            'payment_date' => 'Payment Date',
            'generate' => 'Generate',
            'generated' => 'Generated',
            'regenerate' => 'Regenerate',
            'regenerated' => 'Regenerated',
            'bonus' => 'Bonus',
            'earning' => 'Earning',
            'amount' => 'Amount',
            'add_earning' => 'Add Earning',
            'deduction' => 'Deduction',
            'total_days' => 'Total Days',
            'working_days' => 'Working Days',
            'present_days' => 'Present Days',
            'total_office_time' => 'Total Office Time',
            'total_worked_time' => 'Total Worked Time',
            'half_days' => 'Half Days',
            'late_days' => 'Late Days',
            'paid_leaves' => 'Paid Leaves',
            'unpaid_leaves' => 'Unpaid Leaves',
            'holiday_count' => 'Holiday Count',
            'leaves' => 'Leaves',
            'holiday' => 'Holiday',
            'summary' => 'Summary',
            'pre_payment_deduction' => 'Pre Payment Deduction',
            'salary_component' => 'Salary Component',
            'expense_claim' => 'Expense Claim',
            'basic_salary' => 'Basic Salary',
            'salary_amount' => 'Salary Amount',
            'paid' => 'Paid',
            'generated' => 'Generated',
            'payroll_status' => 'Status',
            'date' => 'Date',
            'payment_mode_id' => 'Payment Mode',
            'status_generated' => 'Status Updated Sucessfully',
            'setup_basic_salary_to_generate_payroll' => 'If you want to generate payroll for an employee then first setup basic salary for that employee.',
            'basic_salary_setup' => 'Basic Salary Setup',
            'payroll_status' => 'Payroll Status',
        ],
        'hrm_dashboard' => [
            'today_attendance' => 'Today Attendance',
            'current_ip_address' => 'Current IP Address',
            'current_time' => 'Current Time',
            'clock_in' => 'Clock In',
            'clocked_in' => 'Clocked In',
            'clock_out' => 'Clock Out',
            'clocked_out' => 'Clocked Out',
            'office_hours_expired' => 'Times Up: Office Hours Expired. Ensure Timely Clock-In and Clock-Out to Keep Attendance Records Accurate.',
            'pening_approvals' => 'Pending Approvals',
            'not_marked' => 'Not Marked',
            'present' => 'Present',
            'absent' => 'Absent',
            'today_is_holiday' => 'Today is holiday...',
            'you_are_on_leave' => 'You are on leave so you cannot clock-in... Enjoy your leave.',
            'self_clocking_is_disabled' => 'Self clocking is disabled by admin',
        ],
        'basic_salary' => [
            'add' => 'Add New Basic Salary',
            'edit' => 'Edit Basic Salary',
            'created' => 'Basic Salary Created Successfully',
            'updated' => 'Basic Salary Updated Successfully',
            'deleted' => 'Basic Salary Deleted Successfully',
            'basic_salary_details' => 'Basic Salary Details',
            'delete_message' => 'Are you sure you want to delete this basic salary?',
            'user_id' => 'User',
            'active' => 'Active',
            'basic_salary' => 'Basic Salary'
        ],
        'hrm_settings' => [
            'updated' => 'HRM Setting Updated Successfully',
            'leave_start_month' => 'Leave Start Month',
            'late_mark_after' => 'Late Mark After',
            'clock_in_time' => 'Clock In Time',
            'clock_out_time' => 'Clock Out Time',
            'self_clocking' => 'Self Clocking',
            'allowed_ip_address' => 'Allowed Ip Address',
            'early_clock_in_time' => 'Early Clock In Time',
            'allow_clock_out_till' => 'Allow Clock Out till',
        ],
        'dashboard' => [
            'dashboard' => 'Dashboard',
            'recent_stock_history' => 'Recent Stock History',
            'top_selling_product' => 'Top Selling Product',
            'sales_purchases' => 'Sales & Purchases',
            'total_sales' => 'Total Sales',
            'top_customers' => 'Top Customers',
            'total_expenses' => 'Total Expenses',
            'payment_sent' => 'Payment Sent',
            'payment_received' => 'Payment Received',
            'total_sales_items' => 'Total Sales Items',
            'total_sales_returns_items' => 'Total Sales Returns Items',
            'total_purchases_items' => 'Total Purchase Items',
            'total_purchase_returns_items' => 'Total Purchase Returns Items',
            'today' => 'Today',
            'last_7_days' => 'Last 7 Days',
            'this_month' => 'This Month',
            'this_year' => 'This Year',
            'yesterday' => 'Yesterday'
        ],
        'user' => [
            'email_phone' => 'Email or Phone',
            'user' => 'User',
            'name' => 'Name',
            'created_at' => 'Created At',
            'email' => 'Email',
            'password' => 'Password',
            'login_enabled' => 'Login Enabled',
            'profile_image' => 'Profile Image',
            'company_name' => 'Company Name',
            'phone' => 'Phone Number',
            'address' => 'Address',
            'city' => 'City',
            'state' => 'State',
            'country' => 'Country',
            'zipcode' => 'Zipcode',
            'billing_address' => 'Billing Address',
            'shipping_address' => 'Shipping Address',
            'opening_balance' => 'Opening Balance',
            'credit_period' => 'Credit Period',
            'credit_limit' => 'Credit Limit',
            'to_receive' => 'To Collect',
            'to_pay' => 'To Pay',
            'receive' => 'Receive',
            'pay' => 'Pay',
            'status' => 'Status',
            'role' => 'Role',
            'days' => 'Day(s)',
            'profile_updated' => 'Profile Updated Successfully',
            'password_blank' => "Leave blank if you don't want to update password.",
            'total_sales' => "Total Sales",
            'total_purchases' => "Total Purchases",
            'walk_in_customer' => "Walk In Customer",
            'staff_members_details' => "Staff Member Details",
            'customers_details' => "Customer Details",
            'suppliers_details' => "Supplier Details",
            'admin_account_details' => "Admin Account Details",
            'tax_number' => 'Tax Number',
            'warehouse_not_changable' => 'Warehouse Can Not Be Changed',
            'sign_in' => 'Sign In',
            'new_password' => 'New Password',
            'confirm_password' => 'Confirm Password',
            'department_id' => 'Department',
            'designation_id' => 'Designation',
            'shift_id' => 'Shift',
            'staff' => 'Staff',
            'basic_salary' => 'Basic Salary'
        ],
        'print_barcode' => [
            'warehouse' => 'Warehouse',
            'paper_size' => 'Paper Size',
            'quantity' => 'Quantity',
            'name' => 'Name',
            'delete_message' => 'Are you sure you want to delete this product?',
            'paper_size' => 'Paper Size',
            'select_name' => 'Select Name',
            'select_price' => 'Select Price'
        ],
        'staff_member' => [
            'add' => 'Add New Staff Member',
            'edit' => 'Edit Staff Member',
            'created' => 'Staff Member Created Successfully',
            'updated' => 'Staff Member Updated Successfully',
            'deleted' => 'Staff Member Deleted Successfully',
            'staff_member_details' => 'Staff Member Details',
            'staff_member' => 'Staff Member',
            'delete_message' => 'Are you sure you want to delete this staff member?',
            'selected_delete_message' => 'Are you sure you want to delete selected staff member?',
            'import_staff_members' => 'Import Staff Members',
        ],
        'customer' => [
            'add' => 'Add New Customer',
            'edit' => 'Edit Customer',
            'created' => 'Customer Created Successfully',
            'updated' => 'Customer Updated Successfully',
            'deleted' => 'Customer Deleted Successfully',
            'customer_details' => 'Customer Details',
            'delete_message' => 'Are you sure you want to delete this customer?',
            'selected_delete_message' => 'Are you sure you want to delete selected customer?',
            'import_customers' => 'Import Customers',
        ],
        'supplier' => [
            'add' => 'Add New Supplier',
            'edit' => 'Edit Supplier',
            'created' => 'Supplier Created Successfully',
            'updated' => 'Supplier Updated Successfully',
            'deleted' => 'Supplier Deleted Successfully',
            'supplier_details' => 'Supplier Details',
            'delete_message' => 'Are you sure you want to delete this supplier?',
            'selected_delete_message' => 'Are you sure you want to delete selected supplier?',
            'import_suppliers' => 'Import Suppliers',
        ],
        'warehouse' => [
            'add' => 'Add New Warehouse',
            'edit' => 'Edit Warehouse',
            'created' => 'Warehouse Created Successfully',
            'updated' => 'Warehouse Updated Successfully',
            'deleted' => 'Warehouse Deleted Successfully',
            'warehouse_details' => 'Warehouse Details',
            'warehouse' => 'Warehouse',
            'logo' => 'Logo',
            'dark_logo' => 'Dark Logo',
            'name' => 'Name',
            'slug' => 'Slug',
            'email' => 'Email',
            'phone' => 'Phone',
            'address' => 'Billing Address',
            'show_email_on_invoice' => 'Show email on invoice',
            'show_phone_on_invoice' => 'Show phone on invoice',
            'terms_condition' => 'Terms & Conditions',
            'bank_details' => 'Bank Details',
            'signature' => 'Signature',
            'delete_message' => 'Are you sure you want to delete this warehouse?',
            'selected_delete_message' => 'Are you sure you want to delete selected warehouse?',
            'details_will_be_shown_on_invoice' => 'Note: Details added below will be shown on your invoices',
            'online_store' => 'Online Store',
            'online_store_status_updated' => 'Online store status updated successfully',
            'no_online_store_exists' => 'No online store exists for this url. Please contact to admin for support.',
            'view_online_store' => 'View Online Store',
            'default_pos_order_status' => 'POS Default Status',
            'basic_details' => 'Basic Details',
            'visibility' => 'Visibility',
            'customers_visibility' => 'Customers Visibility',
            'suppliers_visibility' => 'Suppliers Visibility',
            'products_visibility' => 'Products Visibility',
            'view_all_customers' => 'View All Customers',
            'view_warehouse_customers' => 'View Only Warehouse Customers',
            'view_all_suppliers' => 'View All Suppliers',
            'view_warehouse_suppliers' => 'View Only Warehouse Suppliers',
            'view_all_products' => 'View All Products',
            'view_warehouse_products' => 'View Only Warehouse Products',
            'show_mrp_on_invoice' => 'Show MRP On Invoice',
            'show_discount_tax_on_invoice' => 'Show discount & Tax On Invoice',
            'barcode_type' => 'Barcode Type',
            'barcode' => 'Barcode',
            'qrcode' => 'QR Code'
        ],
        'front_website' => [
            'home' => 'Home',
            'features' => 'Features',
            'pricing' => 'Pricing',
            'contact' => 'Contact',
            'links' => 'Links',
            'pages' => 'Pages',
            'register' => 'Register',
            'company_name' => 'Company Name',
            'email' => 'Email',
            'password' => 'Password',
            'confirm_password' => 'Confirm Password',
            'login' => 'Login',
            'first_name' => 'First Name',
            'last_name' => 'Last Name',
            'address' => 'Address',
            'email' => 'Email',
            'phone' => 'Phone',
            'send_message' => 'Send Message',
            'register_thank_you' => 'Thank you for registration. Please login to get started',
            'error_contact_support' => 'Some error occurred when inserting the data. Please try again or contact support',
            'contact_us_submit_message' => 'Thanks for contacting us. We will catch you soon.',
        ],
        'role' => [
            'add' => 'Add New Role',
            'edit' => 'Edit Role',
            'created' => 'Role Created Successfully',
            'updated' => 'Role Updated Successfully',
            'deleted' => 'Role Deleted Successfully',
            'role_details' => 'Role Details',
            'delete_message' => 'Are you sure you want to delete this role?',
            'selected_delete_message' => 'Are you sure you want to delete selected role?',
            'display_name' => 'Display Name',
            'role_name' => 'Role Name',
            'description' => 'Description',
            'user_management' => 'User Management',
            'permissions' => 'Permissions',
            'approve_reject_leaves' => 'Approve/Reject Leaves',
            'mark_weekend' => 'Mark Weekend',
        ],
        'report' => [
            'by_order' => 'By Orders',
            'by_dates' => 'By Dates',
            'select_date' => 'Select Date',
            'select_date_message' => 'Select a date to view the report',
        ],
        'company' => [
            'add' => 'Add New Company',
            'edit' => 'Edit Company',
            'created' => 'Company Created Successfully',
            'updated' => 'Company Updated Successfully',
            'deleted' => 'Company Deleted Successfully',
            'currency_details' => 'Company Details',
            'delete_message' => 'Are you sure you want to delete this company?',
            'selected_delete_message' => 'Are you sure you want to delete selected company?',
            'name' => 'Company Name',
            'short_name' => 'Company Short Name',
            'email' => 'Company Email',
            'phone' => 'Company Phone',
            'address' => 'Company Address',
            'currency' => 'Currency',
            'logo' => 'Company Logo',
            'left_sidebar_theme' => 'Left Sidebar Theme',
            'dark' => 'Dark',
            'light' => 'Light',
            'dark_logo' => 'Dark Logo',
            'light_logo' => 'Light Logo',
            'small_dark_logo' => 'Small Dark Logo',
            'small_light_logo' => 'Small Light Logo',
            'primary_color' => 'Primary Color',
            'default_timezone' => 'Default Timezone',
            'date_format' => 'Date Format',
            'time_format' => 'Time Format',
            'auto_detect_timezone' => 'Auto Detect Timezone',
            'app_debug' => 'App Debug',
            'update_app_notification' => 'Update App Notitication',
            'login_image' => 'Login Image',
            'layout' => 'Layout',
            'rtl' => 'RTL',
            'ltr' => 'LTR',
            'language' => 'Language',
            'shortcut_menu_Placement' => 'Add Menu Placement',
            'top_and_bottom' => 'Top & Bottom',
            'top_header' => 'Top Header',
            'bottom_corner' => 'Bottom Conrer',
            'shortcut_menu_setting' => 'Add Menu Settings',
            'menu_setting_updated' => 'Menu Setting Updated',
            'basic_details' => 'Basic Details',
            'details' => 'Details',
            'register_date' => 'Register Date',
            'total_users' => 'Total Users',
        ],
        'tax' => [
            'add' => 'Add New Tax',
            'edit' => 'Edit Tax',
            'created' => 'Tax Created Successfully',
            'updated' => 'Tax Updated Successfully',
            'deleted' => 'Tax Deleted Successfully',
            'tax_details' => 'Tax Details',
            'delete_message' => 'Are you sure you want to delete this tax?',
            'selected_delete_message' => 'Are you sure you want to delete selected tax?',
            'display_name' => 'Display Name',
            'name' => 'Name',
            'rate' => 'Tax Rate',
            'no_tax' => 'No Tax',
            'tax_type' => 'Tax Type',
            'single' => 'Single',
            'multiple' => 'Multiple',
            'multiple_tax' => 'Multiple Tax'
        ],
        'variation' => [
            'add' => 'Add New Variation',
            'edit' => 'Edit Variation',
            'created' => 'Variation Created Successfully',
            'updated' => 'Variation Updated Successfully',
            'deleted' => 'Variation Deleted Successfully',
            'variation_details' => 'Variation Details',
            'delete_message' => 'Are you sure you want to delete this variation?',
            'selected_delete_message' => 'Are you sure you want to delete selected variation?',
            'variation_name' => 'Variation Name',
            'name' => 'Name',
            'value' => 'Value',
            'add_new_value' => 'Add New Value',
            'variation_values' => 'Variation Values'
        ],
        'currency' => [
            'add' => 'Add New Currency',
            'edit' => 'Edit Currency',
            'created' => 'Currency Created Successfully',
            'updated' => 'Currency Updated Successfully',
            'deleted' => 'Currency Deleted Successfully',
            'currency_details' => 'Currency Details',
            'delete_message' => 'Are you sure you want to delete this currency?',
            'selected_delete_message' => 'Are you sure you want to delete selected currency?',
            'name' => 'Currency Name',
            'symbol' => 'Currency Symbol',
            'position' => 'Currency Position',
            'front' => 'Front',
            'front_position_example' => 'Example : $100',
            'behind' => 'Behind',
            'behind_position_example' => 'Example : 100$',
            'code' => 'Currency Code',
        ],
        'payment_mode' => [
            'add' => 'Add New Payment Mode',
            'edit' => 'Edit Payment Mode',
            'created' => 'Payment Mode Created Successfully',
            'updated' => 'Payment Mode Updated Successfully',
            'deleted' => 'Payment Mode Deleted Successfully',
            'payment_mode_details' => 'Payment Mode Details',
            'delete_message' => 'Are you sure you want to delete this payment mode?',
            'selected_delete_message' => 'Are you sure you want to delete selected payment mode?',
            'name' => 'Payment Mode Name',
            'mode_type' => 'Mode Type',
            'cash' => 'Cash',
            'bank' => 'Bank',
        ],
        'unit' => [
            'add' => 'Add New Unit',
            'edit' => 'Edit Unit',
            'created' => 'Unit Created Successfully',
            'updated' => 'Unit Updated Successfully',
            'deleted' => 'Unit Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this unit?',
            'selected_delete_message' => 'Are you sure you want to delete selected unit?',
            'unit_details' => 'Unit Details',
            'name' => 'Unit Name',
            'short_name' => 'Short Name',
            'base_unit' => 'Base Unit',
            'operator' => 'Operator',
            'operator' => 'Operator',
            'multiply' => 'Multiply (*)',
            'divide' => 'Divide (/)',
            'operator_value' => 'Operator Value',
        ],
        'custom_field' => [
            'add' => 'Add New Custom Field',
            'edit' => 'Edit Custom Field',
            'created' => 'Custom Field Created Successfully',
            'updated' => 'Custom Field Updated Successfully',
            'deleted' => 'Custom Field Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this custom field?',
            'selected_delete_message' => 'Are you sure you want to delete selected custom field?',
            'name' => 'Field Name',
            'value' => 'Default Value',
            'type' => 'Field Type',
        ],
        'module' => [
            'name' => 'Module Name',
            'verified' => 'Verified',
            'verify_purchase_code' => 'Verify Purchase Code',
            'current_version' => 'Current Version',
            'latest_version' => 'Latest Version',
            'status' => 'Status',
            'installed_modules' => 'Installed Modules',
            'other_modules' => 'Other Modules',
            'module_status_updated' => 'Modules Status Updated',
            'downloading_completed' => 'Download Completed',
            'extract_zip_file' => 'Extract Zip File',
            'file_extracted' => 'Zip File Extracted',
        ],
        'update_app' => [
            'app_details' => 'App Details',
            'name' => 'Name',
            'value' => 'Value',
            'php_version' => 'PHP Version',
            'app_version' => 'App Version',
            'laravel_version' => 'Laravel Version',
            'mysql_version' => 'MySQL Version',
            'vue_version' => 'Vue Version',
            'update_app' => 'Update App',
            'update_now' => 'Update Now',
            'update_available' => 'Update Available',
            'verify_again' => 'Verify Again',
            'verify_failed' => 'Verification Failed',
            'verify_failed_message' => 'Your application is not registerd with us. Please verify it',
            'verified_with_other_domain' => 'Your purchase code is registerd with other doamin. Please verfiy your purhcase code',
        ],
        'expense_category' => [
            'add' => 'Add New Expense Category',
            'edit' => 'Edit Expense Category',
            'created' => 'Expense Category Created Successfully',
            'updated' => 'Expense Category Updated Successfully',
            'deleted' => 'Expense Category Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this expense category?',
            'selected_delete_message' => 'Are you sure you want to delete selected expense category?',
            'expense_category_details' => 'Expense Category Details',
            'name' => 'Expense Category Name',
            'description' => 'Description',
        ],
        'expense' => [
            'add' => 'Add New Expense',
            'edit' => 'Edit Expense',
            'created' => 'Expense Created Successfully',
            'updated' => 'Expense Updated Successfully',
            'deleted' => 'Expense Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this expense?',
            'selected_delete_message' => 'Are you sure you want to delete selected expense?',
            'details' => 'Expense Details',
            'warehouse' => 'Warehouse',
            'expense_category' => 'Expense Category',
            'date' => 'Date',
            'amount' => 'Amount',
            'bill' => 'Expense Bill',
            'user' => 'User',
            'created_by_user' => 'User',
            'notes' => 'Notes',
        ],
        'brand' => [
            'add' => 'Add New Brand',
            'edit' => 'Edit Brand',
            'created' => 'Brand Created Successfully',
            'updated' => 'Brand Updated Successfully',
            'deleted' => 'Brand Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this brand?',
            'selected_delete_message' => 'Are you sure you want to delete selected brand?',
            'details' => 'Brand Details',
            'name' => 'Name',
            'slug' => 'Slug',
            'logo' => 'Brand Logo',
            'import_brands' => 'Import Brands',
        ],
        'category' => [
            'add' => 'Add New Category',
            'edit' => 'Edit Category',
            'created' => 'Category Created Successfully',
            'updated' => 'Category Updated Successfully',
            'deleted' => 'Category Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this category?',
            'selected_delete_message' => 'Are you sure you want to delete selected category?',
            'details' => 'Category Details',
            'category' => 'Category',
            'name' => 'Name',
            'slug' => 'Slug',
            'logo' => 'Category Logo',
            'parent_category' => 'Parent Category',
            'no_parent_category' => 'No Parent Category',
            'import_categories' => 'Import Categories',
        ],
        'product' => [
            'add' => 'Add New Product',
            'edit' => 'Edit Product',
            'created' => 'Product Created Successfully',
            'updated' => 'Product Updated Successfully',
            'deleted' => 'Product Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this product?',
            'selected_delete_message' => 'Are you sure you want to delete selected product?',
            'details' => 'Product Details',
            'name' => 'Name',
            'slug' => 'Slug',
            'sku' => 'SKU',
            'image' => 'Image',
            'quantitiy_alert' => 'Quantity Alert',
            'brand' => 'Brand',
            'category' => 'Category',
            'price' => 'Price',
            'mrp' => 'MRP',
            'purchase_price' => 'Purchase Price',
            'sales_price' => 'Sales Price',
            'tax_type' => 'Tax Type',
            'description' => 'Description',
            'product' => 'Product',
            'quantity' => 'Quantity',
            'discount' => 'Discount',
            'tax' => 'Tax',
            'subtotal' => 'SubTotal',
            'unit' => 'Unit',
            'unit_price' => 'Unit Price',
            'avl_qty' => 'Avl. qty:',
            'order_items' => 'Order Items',
            'inclusive' => 'Inclusive',
            'exclusive' => 'Exclusive',
            'stocks' => 'Stocks',
            'stock_quantity' => 'Stock Quantity',
            'product_orders' => 'Product Orders',
            'stock_history' => 'Stock History',
            'current_stock' => 'Current Stock',
            'item_code' => 'Item Code',
            'barcode_symbology' => 'Barcode Symbology',
            'barcode' => 'Barcode',
            // 'view_barcode' => 'View Barcode',
            'view_barcode' => 'ViewCode',
            'generate_barcode' => 'Generate Barcode',
            'generate_bar' => 'Generate',
            'print_barcode' => 'Print Barcode',
            'price_tax' => 'Price & Tax',
            'variant_details' => 'Variants Details',
            'custom_fields' => 'Custom Fields',
            'wholesale_rate' => 'Wholesale Rate',
            'wholesale_price' => 'Wholesale Price',
            'wholesale_quantity' => 'Wholesale Quantity',
            'enter_min_quantity' => 'Enter Minimum Quantity',
            'opening_stock' => 'Opening Stock',
            'opening_stock_date' => 'Opening Stock Date',
            'stock_value' => 'Stock Value',
            'by_purchase' => 'By Purchase',
            'by_sales' => 'By Sales',
            'unit_sold' => 'Unit Sold',
            'import_products' => 'Import Products',
            'total_purchase_price' => 'Total Purchase Price',
            'total_sales_price' => 'Total Sales Price',
            'product_type' => 'Product Type',
            'search_scan_product' => 'Search Product Name / Item Code / Scan bar code',
            'product_history' => 'Product History',
            'single' => 'Single',
            'variable' => 'Variable',
            'service' => 'Service',
        ],
        'variations' => [
            'add' => 'Add Variation',
            'edit' => 'Edit Variation',
            'add_variation_message' => 'Select Variant and Variant Type From Below Dropdown and Then Click on + Add Variation Button',
            'single_type_product' => 'Single Type Product',
            'variant_type_product' => 'Variant Type Product',
            'variation' => 'Variation',
            'variant_value' => 'Variant Value',
            'service_type_product' => 'Service Type Product',
        ],
        'stock' => [
            'order_type' => 'Order Type',
            'order_date' => 'Order Date',
            'warehouse' => 'Warehouse',
            'supplier' => 'Supplier',
            'customer' => 'Customer',
            'product' => 'Product',
            'invoice_number' => 'Invoice Number',
            'invoie_number_blank' => 'Leave it blank to generate automatically',
            'notes' => 'Notes',
            'status' => 'Order Status',
            'order_tax' => 'Order Tax',
            'discount' => 'Discount',
            'shipping' => 'Shipping',
            'grand_total' => 'Grand Total',
            'remarks' => 'Remarks',
            'pay_now' => 'Pay Now',
            'reset' => 'Reset',
            'total_items' => 'Total Items',
            'paying_amount' => 'Paying Amount',
            'payable_amount' => 'Payable Amount',
            'change_return' => 'Change Return',
            'order_details' => 'Order Details',
            'order_canceled' => 'Order Canceled Successfully',
            'order_cancel_message' => 'Are you sure you want to cancel this order?',
            'view_order' => 'View Order',
            'order_id' => 'Order Id',
            'shipping_address' => 'Shipping Address',
            'billing_address' => 'Billing Address',
            'order_taken_by' => 'Order Taken By',
            'no_product_found' => 'No product found for selected resource',
            'sold_by' => 'Sold By',
            'complete_order' => 'Complete Order',
            'add_order_item' => 'Add Order Item',
            'search_item_to_add' => 'Search item to add in your order',
            'add_pay' => 'Add Pay',
            'pay_amount' => 'Pay Amount',
            'payment_mode' => 'Payment Mode',
            'paid_payment' => 'Paid Payment'
        ],
        'purchase' => [
            'add' => 'Add New Purchase',
            'edit' => 'Edit Purchase',
            'details' => 'Purchase Details',
            'created' => 'Purchase Created Successfully',
            'updated' => 'Purchase Updated Successfully',
            'deleted' => 'Purchase Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this purchase?',
            'selected_delete_message' => 'Are you sure you want to delete selected purchase?',
            'purchase_date' => 'Purchase Date',
            'purchase_status' => 'Purchase Status',
            'user' => 'Supplier',
            'add_pay' => 'Add Pay',
            'pay_amount' => 'Pay Amount',
            'payment_mode' => 'Payment Mode',
        ],
        'sales' => [
            'add' => 'Add New Sales',
            'edit' => 'Edit Sales',
            'details' => 'Sales Details',
            'created' => 'Sales Created Successfully',
            'updated' => 'Sales Updated Successfully',
            'deleted' => 'Sales Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this sales?',
            'selected_delete_message' => 'Are you sure you want to delete selected sales?',
            'sales_date' => 'Sales Date',
            'sales_status' => 'Sales Status',
            'user' => 'Customer',
            'tax_invoice' => 'TAX INVOICE',
            'invoice' => 'Invoice',
            'add_pay' => 'Add Pay',
            'pay_amount' => 'Pay Amount',
            'payment_mode' => 'Payment Mode',
            'add_pay' => 'Add Pay',
            'pay_amount' => 'Pay Amount',
            'payment_mode' => 'Payment Mode',
        ],
        'purchase_returns' => [
            'add' => 'Add New Purchase Return',
            'edit' => 'Edit Purchase Return',
            'details' => 'Purchase Return Details',
            'created' => 'Purchase Return Created Successfully',
            'updated' => 'Purchase Return Updated Successfully',
            'deleted' => 'Purchase Return Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this purchase return?',
            'selected_delete_message' => 'Are you sure you want to delete selected purchase return?',
            'purchase_returns_date' => 'Return Date',
            'purchase_returns_status' => 'Return Status',
            'user' => 'Supplier',
            'add_pay' => 'Add Pay',
            'pay_amount' => 'Pay Amount',
            'payment_mode' => 'Payment Mode',
        ],
        'sales_returns' => [
            'add' => 'Add New Sales Return',
            'edit' => 'Edit Sales Return',
            'details' => 'Sales Return Details',
            'created' => 'Sales Return Created Successfully',
            'updated' => 'Sales Return Updated Successfully',
            'deleted' => 'Sales Return Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this sales return?',
            'selected_delete_message' => 'Are you sure you want to delete selected sales return?',
            'sales_returns_date' => 'Return Date',
            'sales_returns_status' => 'Return Status',
            'user' => 'Customer',
            'add_pay' => 'Add Pay',
            'pay_amount' => 'Pay Amount',
            'payment_mode' => 'Payment Mode',
        ],
        'quotation' => [
            'add' => 'Add New Quotation',
            'edit' => 'Edit Quotation',
            'details' => 'Quotation Details',
            'created' => 'Quotation Created Successfully',
            'updated' => 'Quotation Updated Successfully',
            'deleted' => 'Quotation Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this quotation/estimate?',
            'selected_delete_message' => 'Are you sure you want to delete selected quotation/estimate?',
            'quotation_date' => 'Quotation Date',
            'quotation_status' => 'Quotation Status',
            'user' => 'Customer',
            'tax_invoice' => 'TAX INVOICE',
            'invoice' => 'Invoice',
            'convert_to_sale' => 'Convert to sale',
            'convert_message' => 'Are you really want to convert this quotation to sales?',
            'quotation_converted_to_sales' => 'Quotation converted to sales successfully.',
            'add_pay' => 'Add Pay',
            'pay_amount' => 'Pay Amount',
            'payment_mode' => 'Payment Mode',
        ],
        'payments' => [
            'add' => 'Add New Payment',
            'edit' => 'Edit Payment',
            'details' => 'Payment Details',
            'created' => 'Payment Created Successfully',
            'updated' => 'Payment Updated Successfully',
            'deleted' => 'Payment Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this payment?',
            'selected_delete_message' => 'Are you sure you want to delete selected payment?',
            'user' => 'User',
            'amount' => 'Amount',
            'invoice_amount' => 'Invoice Amount',
            'payment_number' => 'Reference Number',
            'payments' => 'Payments',
            'date' => 'Payment Date',
            'due_amount' => 'Due Amount',
            'paid_amount' => 'Paid Amount',
            'total_amount' => 'Total Amount',
            'unused_amount' => 'Unused Amount',
            'settled_amount' => 'Settled Amount',
            'payment_mode' => 'Payment Mode',
            'paid_total_amount' => 'Paid/Total Amount',
            'notes' => 'Notes',
            'payment_status' => 'Payment Status',
            'unpaid' => 'Unpaid',
            'paid' => 'Paid',
            'transactions' => 'Transactions',
            'transaction_number' => 'Txns No.',
            'partially_paid' => 'Partially Paid',
            'order_payment' => 'Order Payment',
            'settle_invoice_using_payment' => 'Settle below invoices using this payment',
            'payment_type' => 'Payment Type',
            'you_will_pay' => 'You Will Pay',
            'you_will_receive' => 'You Will Receive',
            'cash' => 'Cash',
            'bank' => 'Bank',
            'view_payments' => 'View Payments',
            'payment_details' => 'Payment Details',
            'invoice_number' => 'Invoice Number',
            'customer' => 'Customer',
            'status' => 'Status'
        ],
        'langs' => [
            'add' => 'Add New Language',
            'edit' => 'Edit Language',
            'details' => 'Language Details',
            'created' => 'Language Created Successfully',
            'updated' => 'Language Updated Successfully',
            'deleted' => 'Language Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this language?',
            'selected_delete_message' => 'Are you sure you want to delete selected language?',
            'view_all_langs' => 'View All Languages',
            'status_updated' => 'Langugage status updated',
            'name' => 'Name',
            'key' => 'Key',
            'flag' => 'Flag',
            'enabled' => 'Enabled',
        ],
        'translations' => [
            'fetch_new_translations' => 'Fetch New Translations',
            'reload_translations' => 'Reload Translations',
            'reload_successfully' => 'Translations Reload Successfully',
            'fetched_successfully' => 'Translations Fetch Successfully',
            'import_translations' => 'Import Translations',
        ],
        'storage_settings' => [
            'updated' => 'Storage Settings Updated',
            'storage' => 'Storage',
            'local' => 'Local',
            'aws' => 'AWS S3 Storage',
            'aws_key' => 'AWS Key',
            'aws_secret' => 'AWS Secret',
            'aws_region' => 'AWS Region',
            'aws_bucket' => 'AWS Bucket',
        ],
        'mail_settings' => [
            'updated' => 'Mail Settings Updated',
            'mail_driver' => 'Mail Driver',
            'none' => 'None',
            'mail' => 'Mail',
            'smtp' => 'SMTP',
            'from_name' => 'Mail From Name',
            'from_email' => 'Mail From Email',
            'host' => 'Host',
            'port' => 'Port',
            'encryption' => 'Encryption',
            'username' => 'Username',
            'password' => 'Password',
            'send_test_mail' => 'Send Test Mail',
            'send_mail_setting_saved' => 'Send mail setting saved',
            'enable_mail_queue' => 'Enable Mail Queue',
            'send_mail_for' => 'Send Mail For',
            'email' => 'Email address for which you want to send test mail',
            'test_mail_sent_successfully' => 'Test mail sent successfully',
            'stock_adjustment_create' => 'Stock Adjustment Create',
            'notificaiton_will_be_sent_to_warehouse' => 'Notification will be sent to warehouse email',
        ],
        'online_orders' => [
            'order_summary' => 'Order Summary',
            'cancel_order' => 'Cancel Order',
            'order_cancelled' => 'Order Cancelled',
            'order_cancelled_message' => 'This order has been cancelled.',
            'cancel_message' => 'Are you sure you want to cancel this online order',
            'deliver_message' => 'Are you sure you want to this order as delivered',
            'order_cancelled' => 'Order cancelled successfully',
            'order_confirmed' => 'Order confirmed successfully',
            'order_status_changed' => 'Order status changed successfully',
            'online_orders_date' => 'Order Date',
            'online_orders_status' => 'Order Status',
            'update_orders_status' => 'Update Order Status',
            'confirm_delivery' => 'Confirm Delivery',
            'order_delivered' => 'Order delivered successfully',
            'user' => 'Customer',
            'online_store_url' => 'Online Store Url',
        ],
        'product_card' => [
            'add' => 'Add New Product Card',
            'edit' => 'Edit Product Card',
            'details' => 'Product Card Details',
            'created' => 'Product Card Created Successfully',
            'updated' => 'Product Card Updated Successfully',
            'deleted' => 'Product Card Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this product card?',
            'selected_delete_message' => 'Are you sure you want to delete selected product card?',
            'title' => 'Title',
            'subtitle' => 'Subtitle',
            'products' => 'Products',
        ],
        'front_setting' => [
            'products' => 'Products',
            'featured_categories' => 'Featured Categories',
            'featured_categories_title' => 'Featured Categories Title',
            'featured_categories_subtitle' => 'Featured Categories Subtitle',
            'featured_products' => 'Featured Products',
            'featured_products_title' => 'Featured Products Title',
            'featured_products_subtitle' => 'Featured Products Subtitle',
            'social_links' => 'Social Links',
            'facebook' => 'Facebook',
            'twitter' => 'Twitter',
            'instagram' => 'Instagram',
            'linkedin' => 'Linkedin',
            'youtube' => 'Youttube',
            'footer' => 'Footer',
            'banners' => 'Banners',
            'placeholder_social_text' => 'Please Enter {0} Url',
            'footers' => 'Footers',
            'copyright_text' => 'Copyright Text',
            'addLink' => 'Add Link',
            'addContactLink' => 'Add Contact Link',
            'addPageDetails' => 'Add Pages Details',
            'required_text' => '{0} Required',
            'footer_page_widget' => 'Footer Page Widget',
            'footer_contact_widget' => 'Footer Contact Widget',
            'footer_links_widget' => 'Footer Links Widget',
            'bottom_banners' => 'Bottom Banners',
            'top_banners_1' => 'Top Banner 1',
            'top_banners_2' => 'Top Banner 2',
            'top_banners_3' => 'Top Banner 3',
            'add_to_cart' => 'Add To Cart',
            'footer_company_description' => 'Footer Company Description',
            'useful_links' => 'Useful Links',
            'pages' => 'Pages',
            'contact' => 'Contact',
            'all_categories' => 'All Categories',
            'no_results' => 'No Results',
            'seo_keywords' => 'SEO Keywords',
            'seo_description' => 'SEO Description',
        ],
        'stock_adjustment' => [
            'add' => 'Add New Adjustment',
            'edit' => 'Edit Adjustment',
            'details' => 'Adjustment Details',
            'created' => 'Adjustment Created Successfully',
            'updated' => 'Adjustment Updated Successfully',
            'deleted' => 'Adjustment Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this stock adjustment?',
            'selected_delete_message' => 'Are you sure you want to delete selected stock adjustment?',
            'notes' => 'Notes',
            'current_stock' => 'Current Stock',
            'quantity' => 'Quantity',
            'adjustment_type' => 'Adjustment Type',
            'adjustment_add' => 'Add',
            'adjustment_subtract' => 'Subtract',
        ],
        'stock_transfer' => [
            'add' => 'Add New Transfer',
            'edit' => 'Edit Transfer',
            'details' => 'Transfer Details',
            'created' => 'Transfer Created Successfully',
            'updated' => 'Transfer Updated Successfully',
            'deleted' => 'Transfer Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this stock adjustment?',
            'selected_delete_message' => 'Are you sure you want to delete selected stock adjustment?',
            'stock_transfer_date' => 'Stock Transfer Date',
            'stock_transfer_status' => 'Stock Transfer Status',
            'stock_transfer_transfered' => 'Stock Transfer Transfered',
            'stock_transfer_received' => 'Stock Transfer Received',
            'from_warehouse' => 'From Warehouse',
            'to_warehouse' => 'To Warehouse',
            'warehouse' => 'Warehouse',
            'products' => 'Products',
            'notes' => 'Notes',
            'quantity' => 'Quantity',
            'created_by' => 'Created By',
            'received' => 'Received',
            'transfered' => 'Transfered',
            'add_pay' => 'Add Pay',
            'pay_amount' => 'Pay Amount',
            'payment_mode' => 'Payment Mode',
        ],
        'database_backup' => [
            'file' => 'File',
            'file_size' => 'File Size',
            'generate_backup' => 'Generate Backup',
            'delete_backup' => 'Delete Backup',
            'backup_generated_successfully' => 'Backup Generated Successfully',
            'are_you_sure_generate_backup' => 'Are you sure you want to generate database backup?',
            'are_you_sure_delete_backup' => 'Are you sure you want to delete this database backup?',
            'backup_locaion_is' => 'All generated database file will be stored in storage/app/public/backup folder. ',
            'settings' => 'Command Settings',
            'backup_command_setting' => 'Backup Command Settings',
            'mysqldump_command_path' => 'mysqldump command path',
            'command_updated' => 'Command updated successfully',
            'window_command_path' => 'If you use XAMPP then it will be => C:\xampp\mysql\bin\mysqldump.exe',
            'laragon_command_path' => 'If you use Laragon then it will be => C:\laragon\bin\mysql\mysql-5.7.24-winx64\bin\mysqldump.exe',
            'linux_command_path' => 'If you are on ubuntu or mac then run following command and enter output here => which mysqldump',
            'put_dump_path_command_on_env_file' => 'Find your MySQL dump path from below and then add it to the DUMP_PATH inside .env file',
        ],
        'messages' => [
            'product_out_of_stock' => 'Product is out of stock. Current Stock is {0} while required stock is {1}.',
            'leave_blank_to_create_parent_category' => 'Leave it blank to create parent category',
            'somehing_went_wrong' => 'Something went wrong. Please contact to administrator.',
            'verify_success' => 'Successfully verified. Redirect to app...',
            'login_success' => 'Successfully login. Redirect to app...',
            'login_success_dashboard' => 'Successfully logged into app.',
            'reset_success' => 'Please check the link to set a new password on your gmail...',
            'click_here_to_find_purchase_code' => 'Click here to find your purchase code',
            'verification_successfull' => 'Verification successfully',
            'other_domain_linked' => 'Other domain linked',
            'other_domain_linked_with_purchase_code' => 'Other domain is already linked with your purchase code. Please enter your purchase code for more details...',
            'first_verify_module_message' => 'To enable please \n verify this module',
            'are_you_sure_install_message' => 'Are you sure you want to install?',
            'downloading_started_message' => 'Downloading started. Please wait ...',
            'file_extracting_message' => 'File extracteding. Please wait ...',
            'installation_success' => 'Installation successfully. Click here to reload page...',
            'are_you_sure_update_message' => 'Are you sure you want to update? Please take backup before update.',
            'stmp_success_message' => 'Your SMTP settings are correct..',
            'stmp_error_message' => 'Your SMTP settings are incorrect. Please update it to send mails',
            'uploading_failed' => 'Uploading failed',
            'loading_app_message' => 'Please wait... we are preparing something amazing for you',
            'fetching_product_details' => 'We are fetching product details. Please wait...',
            'product_is_upto_date' => 'You are on the latest version of app.',
            'new_app_version_avaialbe' => 'New app version {0} is available. Please update to get latest version.',
            'not_able_to_edit_order' => 'Only order status editable, other fields can not be editable becuase this order linked to some payments. Delete those payment(s) and try again.',
            'click_here_to_download_sample_file' => 'Click here to download sample csv file',
            'imported_successfully' => 'Imported Successfully',
            'company_admin_password_message' => 'Admin will login using this password. (Leave blank to keep current password)',
            'email_setting_not_configured' => 'Email setting not configured',
            'please_configure_email_settings' => 'Please configure your email settings to send emails. Click Here to configure email settings.',
            'please_login_to_your_account' => 'Please login to your account',
            'reset_password_massage' => 'Great, you have reset your new password!',
        ],
        'popover' => [
            'quantitiy_alert' => 'After this stock quanity it will enable low stock warning.',
            'auto_detect_timezone' => 'Allow auto detect timezone from browser for currently logged in user.',
            'click_here_to_copy_credentials' => 'Click here to copy {0} credentials',
        ],
        'invoice' => [
            'purchase_invoice' => 'Purchase Invoice',
            'purchase_return_invoice' => 'Purchase Return Invoice',
            'sales_invoice' => 'Sales Invoice',
            'sales_return_invoice' => 'Sales Return Invoice',
            'invoice' => 'Invoice',
            'order_date' => 'Date',
            'order_status' => 'Status',
            'payment_status' => 'Payment Status',
            'bill_to' => 'Bill To',
            'product' => 'Product',
            'unit_price' => 'Unit Price',
            'quantity' => 'Quantity',
            'total' => 'Total',
            'mrp' => 'MRP',
            'notes' => 'Notes',
            'subtotal' => 'Subtotal',
            'tax' => 'Tax',
            'discount' => 'Discount',
            'shipping' => 'Shipping',
            'total_items' => 'Total Items',
            'qty' => 'Qty',
            'paid_amount' => 'Paid Amount',
            'due_amount' => 'Due Amount',
            'payment_mode' => 'Payment Mode',
            'total_discount_on_mrp' => 'Total Discount On MRP',
            'total_discount' => 'Total Discount',
            'total_tax' => 'Total Tax',
            'thanks_message' => 'Thank You For Shopping With Us. Please Come Again',
            'quotation_invoice' => 'Quotation Invoice',
            'terms_condition' => 'Terms & Conditions',
            'ref' => 'Ref',
            'sold_by' => 'Sold By',
            'seller' => 'Seller',
            'buyer' => 'Buyer',
            'authorized_person' => 'Authorized Person',
            'bank_details' => 'Bank Details',
        ],
        'front' => [
            'home' => 'Home',
            'profile' => 'Profile',
            'dashboard' => 'Dashboard',
            'my_orders' => 'My Orders',
            'my_profile' => 'My Profile',
            'logout' => 'Logout',
            'total_orders' => 'Total Orders',
            'pending_orders' => 'Pending Orders',
            'processing_orders' => 'Processing Orders',
            'completed_orders' => 'Completed Orders',
            'recent_orders' => 'Recent Orders',
            'order_history' => 'Order History',
            'profile_settings' => 'Profile Settings',
            'select_shipping_address' => 'Select Shipping Address',
            'checkout_page' => 'Checkout Page',
            'address_details' => 'Address Details',
            'payment_details' => 'Payment Details',
            'add_new_address' => 'Add New Address',
            'cash_on_delivery' => 'Cash On Delivery',
            'continue_shopping' => 'Continue Shopping',
            'confirm_order' => 'Confirm Order',
            'confirm_order_message' => 'Are you sure you want to confirm this order?',
            'order_placed' => 'Order placeded.',
            'order_placed_message' => 'Order placed successfully.',
            'all_orders' => 'All Orders',
            'follow_us' => 'Follow Us',
            'categories' => 'Categories',
            'pages' => 'Pages',
            'address_deleted' => 'Address Deleted',
            'address_saved' => 'Address Saved',
            'address_delete_message' => 'Are you sure you want to delete this address?',
            'setting_updated_successfully' => 'Setting updated successfully',
            'login' => 'Login',
            'login_using_email_password' => 'Login using email and password',
            'logged_in_successfully' => 'Logged in successfully',
            'dont_have_account' => "Don't have account?",
            'signup' => "Signup",
            'signup_using_email_password' => "Signup using email & password",
            'already_have_account' => "Already have account",
            'register_successfully' => "Registered successfully",
            'click_here_to_login' => "Click here to login",
        ],
        'topbar_add_button' => [
            'add_staff_member' => 'Add Staff Member',
            'add_customer' => 'Add Customer',
            'add_supplier' => 'Add Supplier',
            'add_brand' => 'Add Brand',
            'add_category' => 'Add Category',
            'add_product' => 'Add Product',
            'add_sales' => 'Add Sales',
            'add_purchase' => 'Add Purchase',
            'add_expense_cateogory' => 'Add Expense Category',
            'add_expense' => 'Add Expense',
            'add_currency' => 'Add Currency',
            'add_warehouse' => 'Add Warehouse',
            'add_unit' => 'Add Unit',
            'add_language' => 'Add Language',
            'add_role' => 'Add Role',
            'add_tax' => 'Add Tax',
            'add_payment_mode' => 'Add Payment Mode',
        ],
        'setup_company' => [
            'setup_not_completed' => 'Setup Not Completed',
            'setup_not_completed_description' => 'Your company default settings not completed. Follow below setups to complete your company basic settings...',
            'warehouse' => 'Warehouse',
            'add_first_warehouse' => 'Add First Warehouse',
            'currency' => 'Currency',
            'add_first_currency' => 'Add First Currency',
            'payment_mode' => 'Payment Mode',
            'add_payment_mode' => 'Add First Payment Mode',
            'company_settings' => 'Company Settings',
            'set_company_basic_settings' => 'Setup Company Basic Settings',
            'previous_step' => 'Previous Step',
            'next_step' => 'Next Step',
            'basic_settings' => 'Basic Settings',
            'theme_settings' => 'Theme Settings',
            'logo_settings' => 'Logo Settings',
            'save_finish_setup' => 'Save & Finish Setup',
            'go_to_dashboard' => 'Go To Dashboard',
            'setup_running_message' => 'Please wait... we are setting up inital company settings.',
            'setup_complete_message' => 'Setup completed... Click on below link to view your app...',
        ]
    ];

    public static $eStoreTranslations = [];

    public static function getTranslationArray($moduleName)
    {
        if ($moduleName == 'Superadmin') {
            return \App\SuperAdmin\Classes\SuperAdminLangTrans::$mainTranslations;
        } else if ($moduleName != '') {
            $className = "Modules\\{$moduleName}\\Classes\LangTrans";
            return $className::$mainTranslations;
        }

        return self::$mainTranslations;
    }

    public static function seedTranslations($moduleName = '')
    {
        $allLangs = Lang::all();

        $translations = self::getTranslationArray($moduleName);

        foreach ($translations as $group => $translation) {
            foreach ($translation as $transKey => $transValue) {

                foreach ($allLangs as $allLang) {
                    $translationCount = Translation::where('lang_id', $allLang->id)
                        ->where('group', $group)
                        ->where('key', $transKey)
                        ->count();

                    if ($translationCount == 0) {
                        $newTranslation = new Translation();
                        $newTranslation->lang_id = $allLang->id;
                        $newTranslation->group = $group;
                        $newTranslation->key = $transKey;
                        $newTranslation->value = $transValue;
                        $newTranslation->save();
                    }
                }
            }
        }
    }

    public static function seedMainTranslations()
    {
        // Main Module
        self::seedTranslations();

        // Seed Translation for SAAS Version
        if (app_type() == 'saas') {
            self::seedTranslations('Superadmin');
        }

        // Seeding modules
        self::seedAllModulesTranslations();
    }

    public static function seedAllModulesTranslations()
    {
        $allModules = Module::all();
        foreach ($allModules as $allModule) {
            self::seedTranslations($allModule);
        }
    }
}
